#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;


#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmTransfusionReactionCountReport
	/// </summary>
	public class FrmTransfusionReactionCountReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Controls

		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.PrintDialog printDialog1;
		private System.Windows.Forms.GroupBox grpImage;
        private System.Windows.Forms.PictureBox picImage;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Variables

        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvTransfusionReactionCount;
        private DataSet _dsReport = new DataSet();

		//
		// BOL Report Object
		private TransfusionReactionReport _transfusionReactionReport;
	
		#endregion

		#region Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmTransfusionReactionCountReport));
            this.btnClose = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            this.rvTransfusionReactionCount = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Transfusion Reaction Count Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnClose
            // 
            this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnClose.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnClose.Location = new System.Drawing.Point(564, 448);
            this.btnClose.Name = "btnClose";
            this.btnClose.Size = new System.Drawing.Size(75, 23);
            this.btnClose.TabIndex = 2;
            this.btnClose.Text = "&Close";
            this.btnClose.Click += new System.EventHandler(this.btnClose_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 448);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 412);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(45, 45);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // rvTransfusionReactionCount
            // 
            this.rvTransfusionReactionCount.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvTransfusionReactionCount.Location = new System.Drawing.Point(60, 37);
            this.rvTransfusionReactionCount.Name = "rvTransfusionReactionCount";
            this.rvTransfusionReactionCount.Size = new System.Drawing.Size(579, 405);
            this.rvTransfusionReactionCount.TabIndex = 6;
            // 
            // FrmTransfusionReactionCountReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnClose;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvTransfusionReactionCount);
            this.Controls.Add(this.btnClose);
            this.Controls.Add(this.btnPrint);
            this.Controls.Add(this.grpImage);
            this.hlphelpChm.SetHelpKeyword(this, "Transfusion_Reaction_Count_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 450);
            this.Name = "FrmTransfusionReactionCountReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Transfusion Reaction Count Report";
            this.Load += new System.EventHandler(this.FrmTransfusionReactionCountReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnClose, 0);
            this.Controls.SetChildIndex(this.rvTransfusionReactionCount, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}

		#endregion

		#region Constructors / Destructors

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmTransfusionReactionCountReport(TransfusionReactionReport transfusionReactionReport)
		{
			this._transfusionReactionReport = transfusionReactionReport;
			//
			InitializeComponent();
			//
			SetComponentProperties();
			//
			this.SetUpReport();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Methods

		/// <summary>
		/// SetUpReport
		/// </summary>
		private void SetUpReport()
		{
			DataSet dsHeader = VbecsReport.GetReportHeader(ThisUser.UserName);
			DataSet dsFooter = VbecsReport.GetReportFooter(this._transfusionReactionReport.GetReportCriteria());
			//
			_dsReport = this._transfusionReactionReport.GetReportData();

			#region Report Data Schema
#if DEBUG
            //reportData.Tables[0].WriteXml("e:\\Temp\\TransfusionReactionCountDataSet.xml", XmlWriteMode.WriteSchema);
            //reportData.Tables[1].WriteXml("e:\\Temp\\TransfusionReactionCountDetailsDataSet.xml", XmlWriteMode.WriteSchema);
            //reportData.Tables[1].WriteXml("e:\\Temp\\TransfusionReactionCountSummaryDataSet.xml", XmlWriteMode.WriteSchema);
#endif
			#endregion


            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReport.Tables.Count > 0)
            {
                reportSourceMain.Name = "TransfusionReactionCountDataSet";
                reportSourceMain.Value = _dsReport.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionCount.TransfusionReactionCountReport.rdlc");
            Stream streamDetail = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionCount.TransfusionReactionCountDetails.rdlc");
            Stream streamSummary = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionCount.TransfusionReactionCountSummary.rdlc");

            this.rvTransfusionReactionCount.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            this.rvTransfusionReactionCount.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvTransfusionReactionCount.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvTransfusionReactionCount.LocalReport.DataSources.Add(reportSourceMain);
            this.rvTransfusionReactionCount.LocalReport.LoadReportDefinition(stream);


            if (this._transfusionReactionReport.DetailedReport)
            {
                this.rvTransfusionReactionCount.LocalReport.LoadSubreportDefinition("TransfusionReactionCountDetails", streamDetail);
            }
            else
            {
                this.rvTransfusionReactionCount.LocalReport.LoadSubreportDefinition("TransfusionReactionCountSummary", streamSummary);
            }

            this.rvTransfusionReactionCount.RefreshReport();

			//
		}

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "TransfusionReactionCountDetails" || e.DataSourceNames[0].ToString() == "TransfusionReactionCountDetailsDataSet")
            {
                ReportDataSource reportDetails = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportDetails.Name = "TransfusionReactionCountDetailsDataSet";
                    reportDetails.Value = _dsReport.Tables[1];
                }
                e.DataSources.Add(reportDetails);
            }
            else if (e.ReportPath == "TransfusionReactionCountSummary" || e.DataSourceNames[0].ToString() == "TransfusionReactionCountSummaryDataSet")
            {
                ReportDataSource reportSummary = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportSummary.Name = "TransfusionReactionCountSummaryDataSet";
                    reportSummary.Value = _dsReport.Tables[1];
                }
                e.DataSources.Add(reportSummary);
            }
        }

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC106.FrmTransfusionReactionCountReport());
            BOL.VbecsReport.SetUpReportButtons(this.rvTransfusionReactionCount);
        }

		#endregion

		#region Events

		/// <summary>
		/// Print_Click
		/// </summary>
		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvTransfusionReactionCount.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

		/// <summary>
		/// Close_Click
		/// </summary>
		private void btnClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		#endregion

        private void FrmTransfusionReactionCountReport_Load(object sender, EventArgs e)
        {

            this.rvTransfusionReactionCount.RefreshReport();
        }
	}
}

